/*
 * Routines for dealing with FMA settable parameters
 */
#include <sys/types.h>
#include <netinet/in.h>

#include "libfma.h"
#include "lf_fabric.h"

#include "fma.h"
#include "fma_settings.h"
#include "fma_myri.h"
#include "fma_verify.h"

/*
 * Initialize FMA settings
 */
void
fma_init_settings_vars()
{
  struct fma_settings *asp;

  LF_CALLOC(asp, struct fma_settings, 1);
  A.settings = asp;

  /* Fill in default values */
  asp->nic_scout_timeout = FMA_DFLT_NIC_SCOUT_TIMEOUT;
  asp->nic_scout_retries = FMA_DFLT_NIC_SCOUT_RETRIES;
  asp->verify_timeout = FMA_DFLT_VERIFY_TIMEOUT;
  asp->verify_retries = FMA_DFLT_VERIFY_RETRIES;
  asp->verify_interval = FMA_DFLT_VERIFY_INTERVAL;
  asp->nic_query_interval = FMA_DFLT_NIC_QUERY_INTERVAL;

  return;

 except:
  fma_perror_exit(1);
}

/*
 * Change settings based on message from FMS
 */
void
fma_fms_set_settings(
  struct lf_fma_settings *msg)
{
  struct fma_settings *asp;

  asp = A.settings;

  /* fill in settings from FMS */
  asp->nic_scout_timeout = ntohl(msg->nic_scout_timeout_32);
  asp->nic_scout_retries = ntohl(msg->nic_scout_retries_32);
  asp->verify_interval = ntohl(msg->verify_interval_32);
  asp->verify_retries = ntohl(msg->verify_retries_32);
  asp->verify_timeout = ntohl(msg->verify_timeout_32);
  asp->nic_query_interval = ntohl(msg->nic_query_interval_32);
  asp->nic_badcrc_threshold = ntohl(msg->nic_badcrc_threshold_32);

  /* inform verify subsystem of new interval */
  fma_new_verify_interval();

  /* (re)start NIC queries */
  fma_start_nic_queries();
}
